#include "CExportDialog.h"
#include <ui_CExportDialog.h>

#include "../../export/ExportController.h"

#include "../../Cache.h"
#include <def.h>

#include <QFileDialog>
#include <QMessageBox>
#include <QDateTime>
#include <QFileInfo>


CExportDialog::CExportDialog(ExportController* exportController, QWidget *parent)
    : QDialog(parent)
    , ui(new Ui::CExportDialog)
    , m_exportController(exportController)
{
    ui->setupUi(this);
    connect(ui->okButton, SIGNAL(clicked()), this, SLOT(tryAccept()));
    connect(ui->cancelButton, SIGNAL(clicked()), this, SLOT(reject()));
    connect(ui->selectButton, SIGNAL(clicked()), this, SLOT(selectFile()));

    m_lastExportPath = Cache::d.value(EXPORT_LAST_USED_FILEPATH, QDir::rootPath()).toString();

    m_lastExportFlags = 0;
    if(ui->tagTypeBox->isChecked())
    	m_lastExportFlags |= ExportController::TagTypeExportFlag;
    if(ui->readCountBox->isChecked())
    	m_lastExportFlags |= ExportController::ReadCountExportFlag;
    if(ui->timeStampBox->isChecked())
    	m_lastExportFlags |= ExportController::TimeStampExportFlag;
    if(ui->readerNameBox->isChecked())
    	m_lastExportFlags |= ExportController::ReaderNameExportFlag;
    if(ui->readerSerialBox->isChecked())
        m_lastExportFlags |= ExportController::ReaderSerialExportFlag;
    if(ui->readerAntennaBox->isChecked())
        m_lastExportFlags |= ExportController::ReaderAntennaExportFlag;
}

CExportDialog::~CExportDialog()
{
    delete ui;
}

QString CExportDialog::lastExportPath() const
{
	return m_lastExportPath;
}

ulong CExportDialog::lastExportFlags() const
{
	return m_lastExportFlags;
}


void CExportDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


int CExportDialog::exec(QString fileName)
{
	ui->fileLineEdit->setText(m_lastExportPath + "/" + fileName);
    return QDialog::exec();
}

void CExportDialog::tryAccept()
{
    m_lastExportFlags = 0;
    if(ui->tagTypeBox->isChecked())
    	m_lastExportFlags |= ExportController::TagTypeExportFlag;
    if(ui->readCountBox->isChecked())
    	m_lastExportFlags |= ExportController::ReadCountExportFlag;
    if(ui->timeStampBox->isChecked())
    	m_lastExportFlags |= ExportController::TimeStampExportFlag;
    if(ui->readerNameBox->isChecked())
    	m_lastExportFlags |= ExportController::ReaderNameExportFlag;
    if(ui->readerSerialBox->isChecked())
        m_lastExportFlags |= ExportController::ReaderSerialExportFlag;
    if(ui->readerAntennaBox->isChecked())
        m_lastExportFlags |= ExportController::ReaderAntennaExportFlag;

    int result = m_exportController->exportTagListToFile(ui->fileLineEdit->text(), m_lastExportFlags);
    if(result != 0)
    {
    	QMessageBox::critical(this, "Error", "An error occured while trying to export the data: " + m_exportController->lastError());
    	return;
    }

	QFileInfo info(ui->fileLineEdit->text());
    Cache::d.setValue(EXPORT_LAST_USED_FILEPATH, info.absolutePath());
    m_lastExportPath = info.absolutePath();

    QDialog::accept();

    QMessageBox::information(this, "Export", "The tag list was successfully exported");
}


void CExportDialog::selectFile()
{
    QString fileName = QFileDialog::getSaveFileName(this, tr("Export"),
    			ui->fileLineEdit->text(),
			    tr("CSV-File (*.csv)"));

    if(!fileName.isNull())
    	ui->fileLineEdit->setText(fileName);
}
